/**
 * Contain the logic for the quick add or update event modal.
 *
 * @module     core_calendar/modal_event_form
 * @copyright  2017 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_calendar/modal_event_form",["jquery","core_form/events","core/str","core/notification","core/templates","core/custom_interaction_events","core/modal","core/modal_registry","core/fragment","core_calendar/events","core_calendar/repository"],(function($,FormEvents,Str,Notification,Templates,CustomEvents,Modal,ModalRegistry,Fragment,CalendarEvents,Repository){var registered=!1,SELECTORS_SAVE_BUTTON='[data-action="save"]',SELECTORS_LOADING_ICON_CONTAINER='[data-region="loading-icon-container"]',ModalEventForm=function(root){Modal.call(this,root),this.eventId=null,this.startTime=null,this.courseId=null,this.categoryId=null,this.contextId=null,this.reloadingBody=!1,this.reloadingTitle=!1,this.saveButton=this.getFooter().find(SELECTORS_SAVE_BUTTON)};return ModalEventForm.TYPE="core_calendar-modal_event_form",(ModalEventForm.prototype=Object.create(Modal.prototype)).constructor=ModalEventForm,ModalEventForm.prototype.setContextId=function(id){this.contextId=id},ModalEventForm.prototype.getContextId=function(){return this.contextId},ModalEventForm.prototype.setCourseId=function(id){this.courseId=id},ModalEventForm.prototype.getCourseId=function(){return this.courseId},ModalEventForm.prototype.setCategoryId=function(id){this.categoryId=id},ModalEventForm.prototype.getCategoryId=function(){return this.categoryId},ModalEventForm.prototype.hasCourseId=function(){return null!==this.courseId},ModalEventForm.prototype.hasCategoryId=function(){return null!==this.categoryId},ModalEventForm.prototype.setEventId=function(id){this.eventId=id},ModalEventForm.prototype.getEventId=function(){return this.eventId},ModalEventForm.prototype.hasEventId=function(){return null!==this.eventId},ModalEventForm.prototype.setStartTime=function(time){this.startTime=time},ModalEventForm.prototype.getStartTime=function(){return this.startTime},ModalEventForm.prototype.hasStartTime=function(){return null!==this.startTime},ModalEventForm.prototype.getForm=function(){return this.getBody().find("form")},ModalEventForm.prototype.disableButtons=function(){this.saveButton.prop("disabled",!0)},ModalEventForm.prototype.enableButtons=function(){this.saveButton.prop("disabled",!1)},ModalEventForm.prototype.reloadTitleContent=function(){return this.reloadingTitle||(this.reloadingTitle=!0,this.hasEventId()?this.titlePromise=Str.get_string("editevent","calendar"):this.titlePromise=Str.get_string("newevent","calendar"),this.titlePromise.then(function(string){return this.setTitle(string),string}.bind(this)).always(function(){this.reloadingTitle=!1}.bind(this)).fail(Notification.exception)),this.titlePromise},ModalEventForm.prototype.reloadBodyContent=function(formData){if(this.reloadingBody)return this.bodyPromise;this.reloadingBody=!0,this.disableButtons();var args={};return this.hasEventId()&&(args.eventid=this.getEventId()),this.hasStartTime()&&(args.starttime=this.getStartTime()),this.hasCourseId()&&(args.courseid=this.getCourseId()),this.hasCategoryId()&&(args.categoryid=this.getCategoryId()),void 0!==formData&&(args.formdata=formData),this.bodyPromise=Fragment.loadFragment("calendar","event_form",this.getContextId(),args),this.setBody(this.bodyPromise),this.bodyPromise.then(function(){this.enableButtons()}.bind(this)).fail(Notification.exception).always(function(){this.reloadingBody=!1}.bind(this)).fail(Notification.exception),this.bodyPromise},ModalEventForm.prototype.reloadAllContent=function(){return $.when(this.reloadTitleContent(),this.reloadBodyContent())},ModalEventForm.prototype.show=function(){this.reloadAllContent(),Modal.prototype.show.call(this)},ModalEventForm.prototype.hide=function(){Modal.prototype.hide.call(this),this.setEventId(null),this.setStartTime(null),this.setCourseId(null),this.setCategoryId(null)},ModalEventForm.prototype.getFormData=function(){return this.getForm().serialize()},ModalEventForm.prototype.save=function(){var invalid,loadingContainer=this.saveButton.find(SELECTORS_LOADING_ICON_CONTAINER);if((invalid=this.getForm().find('[aria-invalid="true"]')).length)return invalid.first().focus(),Promise.resolve();loadingContainer.removeClass("hidden"),this.disableButtons();var formData=this.getFormData();return Repository.submitCreateUpdateForm(formData).then(function(response){if(response.validationerror)this.reloadBodyContent(formData);else{var isExisting=this.hasEventId();this.hide(),isExisting?$("body").trigger(CalendarEvents.updated,[response.event]):$("body").trigger(CalendarEvents.created,[response.event])}}.bind(this)).always(function(){loadingContainer.addClass("hidden"),this.enableButtons()}.bind(this)).fail(Notification.exception)},ModalEventForm.prototype.registerEventListeners=function(){Modal.prototype.registerEventListeners.call(this),this.getModal().on(CustomEvents.events.activate,SELECTORS_SAVE_BUTTON,function(e,data){this.getForm().submit(),data.originalEvent.preventDefault(),e.stopPropagation()}.bind(this)),this.getModal().on("submit",function(e){FormEvents.notifyFormSubmittedByJavascript(this.getForm()[0]),this.save(),e.preventDefault(),e.stopPropagation()}.bind(this))},registered||(ModalRegistry.register(ModalEventForm.TYPE,ModalEventForm,"calendar/modal_event_form"),registered=!0),ModalEventForm}));

//# sourceMappingURL=modal_event_form.min.js.map